#version 430 core
 
layout(triangles, equal_spacing, ccw) in;
 
layout (location = 0) in vec2  tessTexCoords[];
layout (location = 1) in vec4  tessPosition[];

layout (location = 0) out vec2  geoTexCoords;
layout (location = 1) out vec3  geoPosition;
layout (location = 2) out vec3  geoNormal;
layout (location = 3) out float  geoD;

uniform sampler2D noiseTex;

uniform float time;

float PI = 3.14159265359;
uniform vec3 _channelVector;

uniform float lifeRemaining;
uniform float maxLife;
uniform float size;
uniform float defaultSize;
uniform float lifeRatio;


float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }

float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define NUM_OCTAVES 5

float fbm ( in vec3 _st) {
    float v = 0.0;
    float a = 0.5;
    vec3 shift = vec3(100.0);
    // Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    for (int i = 0; i < NUM_OCTAVES; ++i) {
        v += a * noise(_st);
        _st = _st * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}


void main()
{ 
	
	vec2 texCoords = tessTexCoords[0] * gl_TessCoord.x + tessTexCoords[1] * gl_TessCoord.y + tessTexCoords[2] * gl_TessCoord.z; 
	geoTexCoords = texCoords;

	vec3 pos = tessPosition[0].xyz * gl_TessCoord.x + tessPosition[1].xyz * gl_TessCoord.y + tessPosition[2].xyz * gl_TessCoord.z; 

	vec3 noiseCoords = normalize(pos) * 2.0f;

	float q = fbm(noiseCoords);
	
    vec3 r = vec3(0.);
	
    r.x = fbm(noiseCoords + 1.0*q + vec3(1.7,9.2, 1.2));
    r.y = fbm(noiseCoords + 1.0*q + vec3(8.3,2.8, 2.6));
	r.z = fbm(noiseCoords + 1.0*q + vec3(9.3,8.8, 11.2));

	geoNormal = normalize(pos);
	vec3 noise = normalize(r);

	float explosionDMagnitude = defaultSize;
		
	float d = dot(noise, _channelVector) ;
	vec3 vertexAddition = geoNormal * (d * explosionDMagnitude * lifeRatio + size);

	geoD = d;

	gl_Position = vec4(vertexAddition, 1.0);
	geoPosition = vertexAddition;
}
